/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.chuck;

import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class ChuckConfiguration {

    public static final String API_BASE_URL = "https://api.chucknorris.io";
    public static final String JOKES_TYPE = "jokes";

    @UriPath(description = "The endpoint type. Currently, only the 'jokes' type is supported.", enums = JOKES_TYPE)
    @Metadata(required = true)
    private String type;

    @UriParam(label = "proxy", description = "HTTP proxy host which could be used when sending out the message.")
    private String proxyHost;

    @UriParam(label = "proxy", description = "HTTP proxy port which could be used when sending out the message.")
    private Integer proxyPort;

    @UriParam(label = "advanced", description = "Can be used to set an alternative base URL, e.g. when you want to test the component against a mock API.")
    private String baseUrl;
    
    @UriParam(label = "advanced", defaultValue = "4024", description = "AsyncHttpClient buffer size.")
    private int bufferSize = 4 * 1024;

    public ChuckConfiguration() {
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getBufferSize() {
        return bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

}
