/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.chuck;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.chuck.service.ApiService;
import org.apache.camel.support.DefaultAsyncProducer;

public class ChuckProducer extends DefaultAsyncProducer {

    private ChuckEndpoint endpoint;

    public ChuckProducer(ChuckEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (exchange.getIn().getBody() == null) {
            // fail fast
            log.debug("Received exchange with empty body, skipping");
            callback.done(true);
            return true;
        }

        log.debug("Message being sent is: {}", exchange.getIn().getBody(Object.class));
        log.debug("Headers of message being sent are: {}", exchange.getIn().getHeaders());

        final ApiService service = endpoint.getApiService();
        service.randomJoke(exchange, callback);

        return false;
    }

}
